﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
//using System.Linq.Dynamic;

namespace VIRP.AHOBPR.BLL
{
    public static class SortExtensions
    {
        /// <summary>
        /// Sort and page IQuerable object
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="selected"></param>
        /// <param name="sortExpression"></param>
        /// <param name="maximumRows"></param>
        /// <param name="startRowIndex"></param>
        /// <returns></returns>
        public static IQueryable<T> SortAndPage<T>(this IQueryable<T> selected, string sortExpression, int maximumRows, int startRowIndex)
        {
            //if (sortExpression != "")
            //{
            //    sortExpression = "it." + sortExpression;
            //    selected = selected.OrderBy(sortExpression);
            //}

            // Paging report page
            int rowsCount = selected.Count();
            if ((maximumRows > 0) && (startRowIndex > 0))
            {
                if (startRowIndex > rowsCount)
                {
                    startRowIndex = (rowsCount / maximumRows) * maximumRows;
                }
                else if (startRowIndex == rowsCount)
                {
                    startRowIndex = 0;
                }
                else
                {
                    //;
                }

                if (startRowIndex == rowsCount)
                {
                    startRowIndex = 0;
                }

                if (rowsCount - startRowIndex <= maximumRows)
                    return selected.Skip(startRowIndex).Take(rowsCount - startRowIndex);
                else
                    return selected.Skip(startRowIndex).Take(maximumRows);
            }
            else if (startRowIndex > 0)
            {
                return selected.Skip(startRowIndex);
            }
            else if (maximumRows > 0)
            {
                return selected.Take(maximumRows);
            }
            else
            {
                return selected;
            }
        }

        /// <summary>
        /// Sort iQuerable object
        /// </summary>
        /// <typeparam name="T"></typeparam>
        /// <param name="selected"></param>
        /// <param name="sortExpression"></param>
        /// <returns></returns>
        public static IQueryable<T> Sort<T>(this IQueryable<T> selected, string sortExpression)
        {
            //if (sortExpression != "")
            //{
            //    sortExpression = "it." + sortExpression;
            //    selected = selected.OrderBy(sortExpression);
            //}

            return selected;
        }
    }
}
